/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.base.VWString;

public final class VWValidationError {
    public static final int VALIDATION_TYPE_STEP = 1;
    public static final int VALIDATION_TYPE_ROUTE = 2;
    public static final int VALIDATION_TYPE_PARAMETER = 3;
    public static final int VALIDATION_TYPE_FIELD = 4;
    public static final int VALIDATION_TYPE_WORKFLOW = 6;
    public static final int VALIDATION_TYPE_INSTRUCTION = 7;
    public static final int VALIDATION_TYPE_MILESTONE = 8;
    public static final int VALIDATION_TYPE_RULESET = 9;
    public static final int VALIDATION_TYPE_PARTNERLINK = 10;
    public static final int VALIDATION_TYPE_SCHEMA = 11;
    public static final int VALIDATION_TYPE_ANNOTATION = 12;
    public static final int VALIDATION_TYPE_WORKFLOW_COLLECTION = 13;
    public static final int VALIDATION_LEVEL_ERROR = 1;
    public static final int VALIDATION_LEVEL_WARNING = 2;
    private int errorType = -1;
    private int level = 1;
    private String name = null;
    private String message = null;
    private String info = null;
    private int stepId = -1;
    private String mapName = null;
    private int subStepId = -1;
    private static VWString WARN_STR = new VWString("vw.api.VWValidationErrorWarning", "WARNING");
    private static VWString ERR_STR = new VWString("vw.api.VWValidationErrorError", "ERROR");

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-25 21:03:49 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/2 $";
    }

    protected VWValidationError() {
    }

    protected VWValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage, String theMapName) {
        this.errorType = theType;
        this.level = theLevel;
        this.name = theName;
        this.info = theInfo;
        this.mapName = theMapName;
        this.message = theMessage;
    }

    protected VWValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage, String theMapName, int theStepId) {
        this.errorType = theType;
        this.level = theLevel;
        this.name = theName;
        this.info = theInfo;
        this.message = theMessage;
        this.mapName = theMapName;
        this.stepId = theStepId;
    }

    protected VWValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage, String theMapName, int theStepId, int theSubStepId) {
        this.errorType = theType;
        this.level = theLevel;
        this.name = theName;
        this.info = theInfo;
        this.message = theMessage;
        this.mapName = theMapName;
        this.stepId = theStepId;
        this.subStepId = theSubStepId;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public String getMessage() {
        if (this.getLevel() == 2) {
            return "[ " + WARN_STR + " ] " + this.message;
        }
        return "[ " + ERR_STR + " ] " + this.message;
    }

    protected void setMessage(String theMessage) {
        this.message = theMessage;
    }

    public int getErrorType() {
        return this.errorType;
    }

    protected void setErrorType(int theErrorType) {
        this.errorType = theErrorType;
    }

    public int getLevel() {
        return this.level;
    }

    protected void setLevel(int theLevel) {
        this.level = theLevel;
    }

    public int getId() {
        return this.stepId;
    }

    public String getMapName() {
        return this.mapName;
    }

    public int getStepId() {
        return this.stepId;
    }

    public int getSubStepId() {
        return this.subStepId;
    }

    protected void setStepId(int theId) {
        this.stepId = theId;
    }

    protected void setMapName(String theName) {
        this.mapName = theName;
    }

    protected void setSubStepId(int theId) {
        this.subStepId = theId;
    }

    public String toString() {
        String outStr = "";
        switch (this.getErrorType()) {
            case 1: {
                outStr = outStr + "STEP:";
                break;
            }
            case 2: {
                outStr = outStr + "ROUTE:";
                break;
            }
            case 3: {
                outStr = outStr + "PARAMETER:";
                break;
            }
            case 6: {
                outStr = outStr + "WORKFLOW:";
                break;
            }
            case 4: {
                outStr = outStr + "FIELD:";
                break;
            }
            case 7: {
                outStr = outStr + "INSTRUCT:";
                break;
            }
            case 8: {
                outStr = outStr + "MILESTONE:";
                break;
            }
            case 9: {
                outStr = outStr + "RULESET:";
                break;
            }
            case 10: {
                outStr = outStr + "PARTNERLINK:";
                break;
            }
            case 11: {
                outStr = outStr + "SCHEMA:";
                break;
            }
            case 12: {
                outStr = outStr + "ANNOTATION:";
                break;
            }
            case 13: {
                outStr = outStr + "WORKFLOW_COLLECTION:";
            }
        }
        switch (this.getLevel()) {
            case 1: {
                outStr = outStr + ERR_STR + ":";
                break;
            }
            case 2: {
                outStr = outStr + WARN_STR + ":";
            }
        }
        if (this.getName() != null) {
            outStr = outStr + this.getName();
        }
        outStr = outStr + ":";
        if (this.getInfo() != null) {
            outStr = outStr + this.getInfo();
        }
        outStr = outStr + ":";
        outStr = outStr + this.getMapName();
        outStr = outStr + ":";
        outStr = outStr + String.valueOf(this.getStepId());
        outStr = outStr + ":";
        outStr = outStr + String.valueOf(this.getSubStepId());
        outStr = outStr + ":";
        if (this.getMessage() != null) {
            outStr = outStr + this.getMessage();
        }
        outStr = outStr + ":";
        return outStr;
    }
}

